/**========================================================================
 *                           Home Page Banner Slider
 *========================================================================**/
/*============================== Top Hero Slider ==========================*/

const heroSwiper = new Swiper(".hero-slider", {
  loop: true,
  autoplay: {
    delay: 3000,
  },
});

/*============================== Service Slider ===========================*/

const homeServicesSlider = new Swiper(".services-slider", {
  slidesPerView: 1,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
  navigation: {
    nextEl: ".services-slider-next",
    prevEl: ".services-slider-prev",
  },
});

/*============================ Portfolio Slider ============================*/

const portfolioSlider = new Swiper(".portfolio-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 1,
    },
    769: {
      slidesPerView: 2,
    },
    1024: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
  navigation: {
    nextEl: ".portfolio-slider-next",
    prevEl: ".portfolio-slider-prev",
  },
  pagination: {
    el: ".portfolio-slider-pagination",
    clickable: true,
  },
});

/*============================= Article Slider ============================*/

const homeBlogSlider = new Swiper(".blog-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
  navigation: {
    nextEl: ".blog-slider-next",
    prevEl: ".blog-slider-prev",
  },
});

/*================================ Customers Slider ==============================*/

const customersSlider = new Swiper(".customers-slider", {
  slidesPerView: 2,
  loop: true,
  breakpoints: {
    576: {
      slidesPerView: 3,
    },
    768: {
      slidesPerView: 5,
    },
    992: {
      slidesPerView: 7,
    },
    1200: {
      slidesPerView: 8,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 7000,
  },
});

/**========================================================================
 *                                  Blog Page
 *========================================================================**/
/*========================== Blog Categories Slider =======================*/

const blogCategorySlider = new Swiper(".blog-categories-slider", {
  slidesPerView: 2,
  loop: true,
  breakpoints: {
    550: {
      slidesPerView: 3,
    },
    768: {
      slidesPerView: 4,
    },
    992: {
      slidesPerView: 5,
    },
    1200: {
      slidesPerView: 5,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
  navigation: {
    nextEl: ".blog-categories-slider-next",
    prevEl: ".blog-categories-slider-prev",
  },
});

/**========================================================================
 *                           Article Single Page
 *========================================================================**/
/*========================== Similar Article Slider =======================*/

const similarArticlesSlider = new Swiper(".similar-articles-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    1024: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
  navigation: {
    nextEl: ".similar-articles-slider-next",
    prevEl: ".similar-articles-slider-prev",
  },
});

/**========================================================================
 *                               About Us Page
 *========================================================================**/
/*===================== Company Certificates Slider =======================*/

const aboutUsCertificates = new Swiper(".certificates-slider", {
  slidesPerView: 1,
  loop: true,
  breakpoints: {
    550: {
      slidesPerView: 2,
    },
    768: {
      slidesPerView: 3,
    },
    992: {
      slidesPerView: 4,
    },
    1200: {
      slidesPerView: 5,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".certificates-slider-next",
    prevEl: ".certificates-slider-prev",
  },
});

/*======================= Company Employees Slider =======================*/

const companyEmployees = new Swiper(".company-employees-slider", {
  slidesPerView: 1,
  spaceBetween: 15,
  loop: true,
  breakpoints: {
    600: {
      slidesPerView: 2,
    },
    900: {
      slidesPerView: 3,
    },
    1200: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".company-employees-slider-next",
    prevEl: ".company-employees-slider-prev",
  },
});

/**========================================================================
 *                      Service Single Page Sliders
 *========================================================================**/
/*======================= Service Customers Slider =======================*/

const serviceCustomersSlider = new Swiper(".service-customers-slider", {
  slidesPerView: 1,
  loop: true,
  spaceBetween: 10,
  breakpoints: {
    550: {
      slidesPerView: 2,
    },
    768: {
      slidesPerView: 3,
    },
    992: {
      slidesPerView: 4,
    },
    1200: {
      slidesPerView: 5,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  pagination: {
    el: ".service-customers-slider-pagination",
    clickable: true,
  },
});

/*============================ END OF Sliders ============================*/