/*====================== Scroll Up & Fixed Button & Header Background ========================*/

const headerSection = document.querySelector(".header-section");
const supportSocial = document.getElementById("freeSupport");
const scrollButton = document.getElementById("scrollToTop");

//For Scroll Up
scrollButton.onclick = () => {
  document.documentElement.scrollTop = 0;
  document.body.scrollTop = 0;
};

//Apply Change After Scroll
window.onscroll = () => {
  if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
    // Fixed Header
    headerSection.classList.add("header-section-scroll");
    // Visible Support Button
    supportSocial.classList.add("support-social-show");
    // Visible Scroll Up Button
    scrollButton.style.visibility = "visible";
    scrollButton.style.opacity = "1";
  } else {
    // Remove Fixed Style From Header
    headerSection.classList.remove("header-section-scroll");
    // Hide Support Button
    supportSocial.classList.remove("support-social-show");
    // Hide Scroll Up Button
    scrollButton.style.visibility = "hidden";
    scrollButton.style.opacity = "0";
  }
};

/*================================ Article Page ==============================*/

// Apply Sticky Class To Sidebar Or Add Comment Box
let commentsCount = document.querySelectorAll(".user-comment").length;
let addComment = document.querySelector(".add-comment-section");
let newArticles = document.querySelector(".new-articles");
// Check Witch Elements Most Be Sticky Position
commentsCount > 0 ? newArticles.classList.add("position-sticky") : addComment != null ? addComment.classList.add("position-sticky") : console.log();

// For Scroll When Click Table Of Contents Item
function scrollElement(id) {
  let scrollDiv = document.getElementById(id).offsetTop - 250;
  window.scrollTo({ top: scrollDiv, behavior: "smooth" });
}

/*============================ Mobile Menu Accordion ==========================*/

//For Open And Collapse Mobile Menu Accordions
const mobileNavigationAccordion = document.querySelectorAll(".mobile-navigation-accordion-button");
//Add Click Event
mobileNavigationAccordion.forEach((element) => {
  element.addEventListener("click", openAccordion);
});

//Add Open Accordion Class To Clicked Accordion
function openAccordion(event) {
  event.preventDefault();
  event.target.parentElement.classList.toggle("open-mobile-navigation-accordion");
}

/*========================== Read More Description =========================*/

// For Open And Collapse Description
function moreOrLess(e) {
  let description = e.target.previousElementSibling;
  description.classList.toggle("all-description");
  // Change Button Text
  if (description.classList.contains("all-description")) {
    e.target.innerHTML = "نمایش کمتر";
  } else {
    e.target.innerHTML = "نمایش بیشتر";
  }
}

/*============================== Counter Box ==============================*/

// For Count The Numbers Of Counter Boxes
if (document.querySelectorAll(".counter-value") != null) {
  const counter = document.querySelectorAll(".counter-value");
  // Covert To Array
  const array = Array.from(counter);
  // Select Array Element
  array.map((item) => {
    // Data Layer
    let counterInnerText = Number(item.textContent);
    let count = 1;
    let speed = 4000 / counterInnerText;
    function counterUp() {
      item.textContent = count++;
      if (counterInnerText < count) {
        clearInterval(stop);
      }
    }
    const stop = setInterval(() => {
      counterUp();
    }, speed);
  });
}
