/**========================================================================
 *                           Home Page Banner Slider
 *========================================================================**/

const homeHeroSwiper = new Swiper(".home-hero-slider", {
  loop: true,

  autoplay: {
    delay: 3000,
  },
});

const homeServicesSlider = new Swiper(".services-slider", {
  slidesPerView: 1,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".services-slider-next",
    prevEl: ".services-slider-prev",
  },
});

const portfolioSlider = new Swiper(".portfolio-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".portfolio-slider-next",
    prevEl: ".portfolio-slider-prev",
  },
  pagination: {
    el: ".portfolio-slider-pagination",
    clickable: true,
  },
});

const homeBlogSlider = new Swiper(".blog-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".blog-slider-next",
    prevEl: ".blog-slider-prev",
  },
});

const customersSlider = new Swiper(".customers-slider", {
  slidesPerView: 2,
  loop: true,
  autoplay: {
    delay: 1500,
    disableOnInteraction: false,
  },
  breakpoints: {
    576: {
      slidesPerView: 3,
    },
    768: {
      slidesPerView: 5,
    },
    992: {
      slidesPerView: 7,
    },
    1200: {
      slidesPerView: 8,
    },
  },
});

/*============================ END OF Home Page Banner Slider ============================*/

/**========================================================================
 *                           Blog Page
 *========================================================================**/

const blogCategorySlider = new Swiper(".blog-categories-slider", {
  slidesPerView: 2,
  loop: true,
  autoplay: {
    delay: 5000,
    disableOnInteraction: false,
  },
  breakpoints: {
    550: {
      slidesPerView: 3,
    },
    768: {
      slidesPerView: 4,
    },
    992: {
      slidesPerView: 5,
    },
    1200: {
      slidesPerView: 5,
    },
  },
  navigation: {
    nextEl: ".blog-categories-slider-next",
    prevEl: ".blog-categories-slider-prev",
  },
});

/**========================================================================
 *                           Article Single Page
 *========================================================================**/
const similarArticlesSlider = new Swiper(".similar-articles-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    1024: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".similar-articles-slider-next",
    prevEl: ".similar-articles-slider-prev",
  },
});
/**========================================================================
 *                           About Us Page
 *========================================================================**/

const aboutUsCertificates = new Swiper(".about-us-certificates-slider", {
  slidesPerView: 1,
  loop: true,
  autoplay: {
    delay: 8000,
    disableOnInteraction: false,
  },
  breakpoints: {
    550: {
      slidesPerView: 2,
    },
    768: {
      slidesPerView: 3,
    },
    992: {
      slidesPerView: 4,
    },
    1200: {
      slidesPerView: 5,
    },
  },
  navigation: {
    nextEl: ".about-us-certificates-slider-next",
    prevEl: ".about-us-certificates-slider-prev",
  },
});

const companyEmployees = new Swiper(".company-employees-slider", {
  slidesPerView: 1,
  spaceBetween: 15,
  loop: true,
  autoplay: {
    delay: 8000,
    disableOnInteraction: false,
  },
  breakpoints: {
    600: {
      slidesPerView: 2,
    },
    900: {
      slidesPerView: 3,
    },
    1200: {
      slidesPerView: 4,
    },
  },
  navigation: {
    nextEl: ".company-employees-slider-next",
    prevEl: ".company-employees-slider-prev",
  },
});

/*================================ End Of Blog Page ==============================*/

/**------------------------------------------------------------------------
 *               Products Page Sliders For Product Images
 *------------------------------------------------------------------------**/

const productSliderThumbnail = new Swiper(".product-slider-thumbnail", {
  loop: true,
  spaceBetween: 10,
  slidesPerView: 4,
  freeMode: true,
});
const productSlider = new Swiper(".product-image-slider", {
  loop: true,
  spaceBetween: 10,
  navigation: {
    nextEl: ".product-slider-next",
    prevEl: ".product-slider-prev",
  },
  thumbs: {
    swiper: productSliderThumbnail,
  },
});

/*---------------------------- END OF Products Page Sliders ----------------------------*/

/**========================================================================
 *                           Service Single Pgae
 *========================================================================**/

const serviceCustomersSlider = new Swiper(".service-customers-slider", {
  slidesPerView: 1,
  loop: true,
  spaceBetween: 10,
  autoplay: {
    delay: 8000,
    disableOnInteraction: false,
  },
  breakpoints: {
    550: {
      slidesPerView: 2,
    },
    768: {
      slidesPerView: 3,
    },
    992: {
      slidesPerView: 4,
    },
    1200: {
      slidesPerView: 5,
    },
  },
  pagination: {
    el: ".service-customers-slider-pagination",
    clickable: true,
  },
});