/**========================================================================
 *                           Home Page Banner Slider
 *========================================================================**/

const homeHeroSwiper = new Swiper(".home-hero-slider", {
  loop: true,

  autoplay: {
    delay: 3000,
  },
});

const homeServicesSlider = new Swiper(".services-slider", {
  slidesPerView: 1,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".services-slider-next",
    prevEl: ".services-slider-prev",
  },
});

const portfolioSlider = new Swiper(".portfolio-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".portfolio-slider-next",
    prevEl: ".portfolio-slider-prev",
  },
});

const homeBlogSlider = new Swiper(".blog-slider", {
  slidesPerView: 1,
  speed: 1500,
  breakpoints: {
    576: {
      slidesPerView: 2,
    },
    769: {
      slidesPerView: 3,
    },
    1024: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    delay: 5000,
  },
  navigation: {
    nextEl: ".blog-slider-next",
    prevEl: ".blog-slider-prev",
  },
});

const customersSlider = new Swiper(".customers-slider", {
  slidesPerView: 2,
  loop: true,
  autoplay: {
    delay: 1500,
    disableOnInteraction: false,
  },
  breakpoints: {
    576: {
      slidesPerView: 3,
    },
    768: {
      slidesPerView: 5,
    },
    992: {
      slidesPerView: 7,
    },
    1200: {
      slidesPerView: 8,
    },
  },
});
/*============================ END OF Home Page Banner Slider ============================*/

/**------------------------------------------------------------------------
 *               Products Page Sliders For Product Images
 *------------------------------------------------------------------------**/

const productSliderThumbnail = new Swiper(".product-slider-thumbnail", {
  loop: true,
  spaceBetween: 10,
  slidesPerView: 4,
  freeMode: true,
});
const productSlider = new Swiper(".product-image-slider", {
  loop: true,
  spaceBetween: 10,
  navigation: {
    nextEl: ".product-slider-next",
    prevEl: ".product-slider-prev",
  },
  thumbs: {
    swiper: productSliderThumbnail,
  },
});

/*---------------------------- END OF Products Page Sliders ----------------------------*/
